// This pattern uses a 14N march algorithm to test
// the upper 32k of the KRAM.  

#include "environment.h"
#include "march.h"
#include "m5282evb.h"

#define SIZE 2048

void main (void) {
   	UINT32 *KRAM32kbase;
   	int i;
   	int result;
   
   	ASM(move.w #0x2000,sr); // Set supervisor mode
   	WR32(RAMBAR1,0x01000200); //Move mirror RAM
   	KRAM32kbase=(UINT32*)(0x01008000);
   
   /*Configure PORT D as GPIO*/	
	MCF5282_GPIO_PBCDPAR = (0x0);
	COMMENT("Configure PORTD as GPIO outputs\n");
   	WR8(MCF5282_GPIO_DDRD, 0xFF);
   	COMMENT("Initialize PORTD to 0 - used as FAIL\n");
   	WR8(MCF5282_GPIO_PORTD, 0x00);

  	/* Protect IPSBAR space from data caching*/
   	ASM(move.l #0x4000C040,d0);
   	ASM(movec d0,acr1);
   
  	 /*Disable and invalidate the entire cache*/
   	ASM(move.l #0x01800103,d0);  /* disable-and-invalidate cache CACR value*/
   	ASM(movec d0,cacr);
  	 
   	/*Enable the cache (as data only)*/
   	ASM(move.l #0x80800103,d0);  /* enable-and-unlock-cache CACR value*/
   	ASM(movec d0,cacr);	

   	result = march (KRAM32kbase, SIZE);
   
   	COMMENT("march returned, write result to PORTD\n");
   	WR8(MCF5282_GPIO_PORTD, result);
   	 
   	for (i=0; i<100; i++); /*Keep the result around for a while*/
   	
   	switch (result) {
    	case MARCHPASS:  
    		COMMENT ("MARCHPASS.\n");  
    		break;
      	case FAILFILL:   
      		COMMENT("FAILFILL.\n");  
      		break;
      	case FAILCOMPL1: 
      		COMMENT("FAILCOMPL1.\n");  
      		break;
      	case FAILCOMPL2: 
      		COMMENT("FAILCOMPL2.\n");  
      		break;
      	case FAILPAT2:   
      		COMMENT("FAILPAT2.\n"); 
      		break;
      	case FAILPAT3:   
      		COMMENT("FAILPAT3.\n");  
      		break;
      	case FAILCOMPL3: 
      		COMMENT("FAILCOMPL3.\n");  
      		break;
      	case FAILCOMPL4: 
      		COMMENT("FAILCOMPL4.\n");  
      		break;
      	case FAILPAT4:   
      		COMMENT("FAILPAT4.\n");  
      		break;
      	case FAILPAT5:   
      		COMMENT("FAILPAT5.\n");  
      		break;
   	}
   	while(1)
   	{
   	}
}

/********************************************************************/
__interrupt__
void irq7_handler (void) 
{
}


/********************************************************************/
__interrupt__
void swt_handler (void) 
{
	
}